//
//  SPLinearGradient.h
//  SamplePlugIn
//
//  Created by Kai on 27.1.08.
//  Copyright 2008 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

/**
 This class represents a linear gradient as a top level object in nib files.
 
 TODO: move to AppKit, NSColor is in AppKit
 */

@interface SPLinearGradient : NSObject <NSCopying, NSCoding>

{
	@private
		NSColor*		_startingColor;
		NSColor*		_endingColor;
		float			_angle;

		NSGradient*	_gradient;
}

- (id) initWithStartingColor:(NSColor*)startingColor
					  endingColor:(NSColor*)endingColor
							  angle:(float)angle;

- (NSColor*) startingColor;
- (void) setStartingColor:(NSColor*)value;

- (NSColor*) endingColor;
- (void) setEndingColor:(NSColor*)value;

- (float) angle;
- (void) setAngle:(float)value;

/*! Returns the gradient which is used for drawing. */
- (NSGradient*) gradient;

/*! Draws the gradient to fill a rectangle. Draws a linear gradient clipped to the provided
 rect. The start point and end point are calculated with respect to the provided rect so that
 the gradient is drawn at the angle in degrees. The end points are located such that both the
 start and end color in the gradient are visible in the rect.
 */
- (void) drawInRect:(NSRect)rect;


/* Draws the gradient to fill a path. Draws a linear gradient clipped by the provided path.
 The start point and end point are calculated with respect to the provided path so that the
 gradient is drawn at the angle in degrees. The end points are located such that both the
 start and end color in the gradient are visible in the path.
 */
- (void) drawInBezierPath:(NSBezierPath*)path;


@end
